
 
; Temp-cricket-ure
; chirps the temperature. Various modes available


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
	__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON  & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

; EEPROM
EEPROM0			equ	H'00'	; non-volatile storage for mode
; RAM 

STORE1			equ	H'20'	; delay counter	
STORE2			equ	H'21'	; delay counter
STORE3			equ	H'22'	; delay counter
TEMP0			equ	H'23'	; storage
MODE			equ	H'24'	; reporting MODE
TEMP			equ	H'25'	; temporary
SOFT_START	equ	H'26'	; soft start timer
SOFT_STORE	equ	H'27'	; store soft start
SOFT_END		equ	H'28'	; subtraction value8
FASTER			equ	H'29'	; count in fives, sixes or tens rate
COUNT_VIX		equ	H'2A'	; counter for in sixes or 10's
QUIETING		equ	H'2B'	; quiet period counter with LDR detection
WAIT			equ	H'2C'	; switch to close waiting period
TEMPT			equ	H'2D'	; temperature value
TIME			equ	H'2E'	; extra timer divider for LDR or random time period
				
; random number generator registers
BARGB0			equ	H'31'	; random number generator
BARGB1			equ	H'32'	; random number generator
BARGB2			equ	H'33'	; random number generator
AARGB0			equ	H'34'	; random number gen
AARGB1			equ	H'35'	; random number gen
AARGB2			equ	H'36'	; random number gen
AARGB3			equ	H'37'	; random number gen
AARGB4			equ	H'38'	; random number gen
AARGB5			equ	H'39'	; random number gen
AARGB6			equ	H'3A'	; random number gen
RANDB0			equ	H'3B'	; random number seed
RANDB1			equ	H'3C'	; random number seed
RANDB2			equ	H'3D'	; random number seed
RANDB3			equ	H'3E'	; random number seed
TEMPB0			equ	H'3F'	; random gen temp files
TEMPB1			equ	H'40'	; random gen temp files
TEMPB2			equ	H'41'	; random gen temp files
TEMPB3			equ	H'42'	; random gen temp files
LOOPCOUNT		equ	H'43'	; loop counter in random gen


; preprogram EEPROM DATA 
	
	ORG     H'2100'
	DE		H'0' ; 0=MODE1, 1=MODE2 etc ie MODE(X)=value +1

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN
; interrupt vector (not used)
	
; **********************************************************
	
; Lookup table for temperature
TEMP_CALC
; subtract 50 from w (A/D value for 60 degrees C)
; return value is degrees C based on A/D value from  voltage divider with 10k and thermistor.  (NTC thermistor is 10k at 25 deg C and with a Beta of 3960)
	movwf	TEMP
	movlw	D'50'
	subwf	TEMP,w
	btfss	STATUS,C	; if clear (ie less than 50) return with D'60'
	retlw	D'60'		; maximum 60 degrees even if it is more
	addwf	PCL,f		; add to program counter
	retlw	D'60'		; for A/D of 50

	retlw	D'59'		; for A/D of 51
	retlw	D'59'		; for A/D of 52
	retlw	D'58'		; for A/D of 53
	retlw	D'57'		; for A/D of 54
	retlw	D'57'		; for A/D of 55

	retlw	D'56'		; for A/D of 56
	retlw	D'55'		; for A/D of 57
	retlw	D'55'		; for A/D of 58
	retlw	D'54'		; for A/D of 59
	retlw	D'54'		; for A/D of 60

	retlw	D'53'		; for A/D of 61
	retlw	D'52'		; for A/D of 62
	retlw	D'52'		; for A/D of 63
	retlw	D'51'		; for A/D of 64
	retlw	D'51'		; for A/D of 65

	retlw	D'50'		; for A/D of 66
	retlw	D'50'		; for A/D of 67
	retlw	D'49'		; for A/D of 68
	retlw	D'49'		; for A/D of 69
	retlw	D'48'		; for A/D of 70

	retlw	D'48'		; for A/D of 71
	retlw	D'47'		; for A/D of 72
	retlw	D'47'		; for A/D of 73
	retlw	D'46'		; for A/D of 74
	retlw	D'46'		; for A/D of 75

	retlw	D'45'		; for A/D of 76
	retlw	D'45'		; for A/D of 77
	retlw	D'44'		; for A/D of 78
	retlw	D'44'		; for A/D of 79
	retlw	D'43'		; for A/D of 80

	retlw	D'43'		; for A/D of 81
	retlw	D'42'		; for A/D of 82
	retlw	D'42'		; for A/D of 83
	retlw	D'41'		; for A/D of 84
	retlw	D'41'		; for A/D of 85

	retlw	D'41'		; for A/D of 86
	retlw	D'40'		; for A/D of 87
	retlw	D'40'		; for A/D of 88
	retlw	D'39'		; for A/D of 89
	retlw	D'39'		; for A/D of 90

	retlw	D'38'		; for A/D of 91
	retlw	D'38'		; for A/D of 92
	retlw	D'38'		; for A/D of 93
	retlw	D'37'		; for A/D of 94
	retlw	D'37'		; for A/D of 95

	retlw	D'36'		; for A/D of 96
	retlw	D'36'		; for A/D of 97
	retlw	D'36'		; for A/D of 98
	retlw	D'35'		; for A/D of 99
	retlw	D'35'		; for A/D of 100

	retlw	D'34'		; for A/D of 101
	retlw	D'34'		; for A/D of 102
	retlw	D'34'		; for A/D of 103
	retlw	D'33'		; for A/D of 104
	retlw	D'33'		; for A/D of 105

	retlw	D'32'		; for A/D of 106
	retlw	D'32'		; for A/D of 107
	retlw	D'32'		; for A/D of 108
	retlw	D'31'		; for A/D of 109
	retlw	D'31'		; for A/D of 110

	retlw	D'31'		; for A/D of 111
	retlw	D'30'		; for A/D of 112
	retlw	D'30'		; for A/D of 113
	retlw	D'29'		; for A/D of 114
	retlw	D'29'		; for A/D of 115

	retlw	D'29'		; for A/D of 116
	retlw	D'28'		; for A/D of 117
	retlw	D'28'		; for A/D of 118
	retlw	D'28'		; for A/D of 119
	retlw	D'27'		; for A/D of 120

	retlw	D'27'		; for A/D of 121
	retlw	D'27'		; for A/D of 122
	retlw	D'26'		; for A/D of 123
	retlw	D'26'		; for A/D of 124
	retlw	D'26'		; for A/D of 125

	retlw	D'25'		; for A/D of 126
	retlw	D'25'		; for A/D of 127
	retlw	D'24'		; for A/D of 128
	retlw	D'24'		; for A/D of 129
	retlw	D'24'		; for A/D of 130

	retlw	D'23'		; for A/D of 131
	retlw	D'23'		; for A/D of 132
	retlw	D'23'		; for A/D of 133
	retlw	D'22'		; for A/D of 134
	retlw	D'22'		; for A/D of 135

	retlw	D'22'		; for A/D of 136
	retlw	D'21'		; for A/D of 137
	retlw	D'21'		; for A/D of 138
	retlw	D'21'		; for A/D of 139
	retlw	D'20'		; for A/D of 140

	retlw	D'20'		; for A/D of 141
	retlw	D'20'		; for A/D of 142
	retlw	D'19'		; for A/D of 143
	retlw	D'19'		; for A/D of 144
	retlw	D'19'		; for A/D of 145

	retlw	D'18'		; for A/D of 146
	retlw	D'18'		; for A/D of 147
	retlw	D'18'		; for A/D of 148
	retlw	D'17'		; for A/D of 149
	retlw	D'17'		; for A/D of 150

	retlw	D'17'		; for A/D of 151
	retlw	D'16'		; for A/D of 152
	retlw	D'16'		; for A/D of 153
	retlw	D'16'		; for A/D of 154
	retlw	D'15'		; for A/D of 155

	retlw	D'15'		; for A/D of 156
	retlw	D'15'		; for A/D of 157
	retlw	D'14'		; for A/D of 158
	retlw	D'14'		; for A/D of 159
	retlw	D'14'		; for A/D of 160

	retlw	D'13'		; for A/D of 161
	retlw	D'13'		; for A/D of 162
	retlw	D'12'		; for A/D of 163
	retlw	D'12'		; for A/D of 164
	retlw	D'12'		; for A/D of 165

	retlw	D'11'		; for A/D of 166
	retlw	D'11'		; for A/D of 167
	retlw	D'11'		; for A/D of 168
	retlw	D'10'		; for A/D of 169
	retlw	D'10'		; for A/D of 170

	retlw	D'10'		; for A/D of 171
	retlw	D'9'			; for A/D of 172
	retlw	D'9'			; for A/D of 173
	retlw	D'9'			; for A/D of 174
	retlw	D'8'			; for A/D of 175

	retlw	D'8'			; for A/D of 176
	retlw	D'7'			; for A/D of 177
	retlw	D'7'			; for A/D of 178
	retlw	D'7'			; for A/D of 179
	retlw	D'6'			; for A/D of 180

	retlw	D'6'			; for A/D of 181
	retlw	D'5'			; for A/D of 182
	retlw	D'5'			; for A/D of 183
	retlw	D'5'			; for A/D of 184
	retlw	D'4'			; for A/D of 185

	retlw	D'4'			; for A/D of 186
	retlw	D'4'			; for A/D of 187
	retlw	D'3'			; for A/D of 188
	retlw	D'3'			; for A/D of 189
	retlw	D'3'			; for A/D of 190

	retlw	D'2'			; for A/D of 191
	retlw	D'2'			; for A/D of 192
	retlw	D'1'			; for A/D of 193
	retlw	D'1'			; for A/D of 194
	retlw	D'0'			; for A/D of 195

	retlw	D'0'			; for A/D of 196
	retlw	D'0'			; for A/D of 197
	

; Lookup tables for cricket chirp

GAP			; gap between individual bursts
	addwf	PCL,f		; add w to program counter (8max)
	retlw	D'45'
	retlw	D'40'		; 40= 18ms
	retlw	D'41'
	retlw	D'40'
	retlw	D'41'
	retlw	D'39'
	retlw	D'38'
	retlw	D'41'
	retlw	D'40'
	
BURST		; individual burst length within triplet
	addwf	PCL,f		; add w to program counter (16max)
	retlw	D'71'		; 70 = 20ms
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'71'
	retlw	D'70'
	retlw	D'73'
	retlw	D'71'
	retlw	D'71'
	retlw	D'70'
	retlw	D'72'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'
	retlw	D'70'

SEPARATION			; separation between the triple burst
	addwf	PCL,f		; add w to program counter (32max)
	retlw	D'75'	
	retlw	D'71'	; 80 = 320ms
	retlw	D'70'
	retlw	D'72'
	retlw	D'77'
	retlw	D'75'	
	retlw	D'100'	
	retlw	D'80'
	retlw	D'100'
	retlw	D'76'
	retlw	D'77'
	retlw	D'75'
	retlw	D'72'	
	retlw	D'75'
	retlw	D'78'
	retlw	D'75'
	retlw	D'77'
	retlw	D'61'
	retlw	D'63'
	retlw	D'61'
	retlw	D'65'
	retlw	D'71'
	retlw	D'75'
	retlw	D'72'
	retlw	D'73'
	retlw	D'75'	
	retlw	D'70'
	retlw	D'76'
	retlw	D'77'
	retlw	D'76'	
	retlw	D'75'
	retlw	D'70'
	retlw	D'75'

; ***********************************************************
		
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'			; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
	movlw	B'00000010'
	movwf	GPIO		; GP1 high
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000000'	; pullups off
	movwf	WPU
	movlw	B'00001101'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00001111'	; settings (pullups disabled) wdt prescaler/128 (18ms x 128 timeout= 2.3s) GPIO2 interrupt on a low
	movwf	OPTION_REG
; analog inputs, A/D
	movlw	B'01010001'
	movwf	ANSEL		; digital I/O and analog at AN0

	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'	; channel 0, left justified, VDD ref etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	bsf		GPIO,1			; set high
	nop
	nop
	nop

; check if S1 pressed at power up
	btfsc	GPIO,2
	goto	MODE_SHOW
; switch closed; change mode
; MODE1 counts temperature one chirp per deg
; MODE2 quick set of chirps is a 6, single chirp a 1
; MODE3 quick set of chirps is a 6, single chirp a 1
; MODE4 10's chirp initially indicated with (LED1), 1's initially indicated with (LED2) 
; Modes 5, 6, 7 & 8 are similar to MODEs1, 2, 3 & 4 except that these also run automatically and periodically when  in darkness as well as with an S1 press
; Modes 9, 10, 11 & 12 are similar to MODEs1, 2, 3 & 4 except that these also run automatically and periodically when  in day as well as with an S1 press
; Modes 13, 14,15 & 16 are similar to MODEs1, 2, 3 & 4 except that these also run automatically and periodically when  in both darkness and day as well as with an S1 press
 
; adjust MODE by number of switch presses using initial chirp as an indication to start

	call		SOUND		; initial start indicator 1 chirp

	movlw	H'FF'
	movwf	TEMP		; start at 1 less than zero
	
; 	wait for S1 open
WAIT_S1
	call		DELAY_FLASH
	btfss	GPIO,2
	goto	WAIT_S1
; switch open
; wait for switch to close
; firstly set up a maximum period to wait
	movlw	D'30'
	movwf	WAIT
W_CLOSE; wait till closed.

;  If initially never pressed again then use original MODE value
		
	movlw	D'255'
	call		DELAYX
	btfss	GPIO,2
	goto	CLOSED1
	decfsz	WAIT,f
	goto	W_CLOSE
	call		SOUND		; error indicator 3-chirps
	call		DELAYX
	call		SOUND		; error indicator
	call		DELAYX
	call		SOUND		; error indicator
	goto	MODE_SHOW

CLOSED1; switch closed
	call		SOUND		; switch press indicator
	movlw	D'1'
	addwf	TEMP,f		; next value
	movf	TEMP,w
	sublw	D'15'		; mode value
	btfss	STATUS,C	; if over
	clrf		TEMP		; clear if over
	movf	TEMP,w
; 	wait for S1 open
WAIT_S1_1
	call		DELAY_FLASH
	btfss	GPIO,2
	goto	WAIT_S1_1

; firstly set up a maximum period to wait for a switch press before exiting
	movlw	D'30'
	movwf	WAIT

W_CLOSED; wait till closed.

;  when left open, store new MODE
		
	movlw	D'255'
	call		DELAYX
	btfss	GPIO,2
	goto	CLOSED1
	decfsz	WAIT,f
	goto	W_CLOSED
	call		SOUND		; end indicator 2-chirps
	call		DELAYX
	call		SOUND 

; write to EEPROM
	movf	TEMP,w
	movwf	MODE
	call		EEWRITE	; write to EEPROM

; show selected MODE
MODE_SHOW
	call		EEREAD	; read EEPROM0 for MODE
	movwf	TEMP
	movwf	MODE
	incf		TEMP,f		; increase by 1 so a 0 is shown as a 1. 

; if MODE is 10 or more flash LED1 once (10's) and LED2  to add in the extra counts
	incf		MODE,w
	sublw	D'9'
	btfss	STATUS,C
	goto	MODE_SHOW_10
	 
MODE_SHOW_CYCLE ; (count the MODE using LED2)
	movlw	D'05'
	movwf	STORE3
TIMER_S
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_S
; flash mode number 
	bsf		GPIO,5		; LED2 on
	movlw	D'5'
	movwf	STORE3

TIMER_O
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_O
	bcf		GPIO,5		; LED2 off
	decfsz	TEMP,f
	goto	MODE_SHOW_CYCLE
	goto	END_MODE_SHOW

MODE_SHOW_10 ; (show 10s and then 1's on LED1 and LED2)
	movlw	D'05'
	movwf	STORE3
TIMER_10S
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_10S
; flash mode number 
	bsf		GPIO,4		; LED1 on
	movlw	D'5'
	movwf	STORE3

TIMER_10O
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_10O
	bcf		GPIO,4		; LED2 off
; show 1's
	movlw	D'10'		; take 10 off MODE for remainder above 10
	subwf	TEMP,f	
	btfss	STATUS,Z	; if zero the Mode was 10 so end of MODE show
	goto	MODE_SHOW_CYCLE; show remaining 1's

END_MODE_SHOW
; enable wake from sleep with a low edge signal on GP2
	bsf		INTCON, INTE	; GP2 edge interrupt
	bcf		INTCON,INTF		; GP2 interrupt flag
; initial conditions
	movlw	B'00000010'
	movwf	GPIO		; GP1 high
; set initial seed value
	movlw	0x27			; random seed value
	movwf	RANDB0
	movlw	0xF1
	movwf	RANDB1
	movlw	0x20			; random seed value
	movwf	RANDB2
	movlw	0x49
	movwf	RANDB3
	call		RAND32			; random number generator

; preload quieting 
	movf	AARGB2,w		; random value
	iorlw 	B'00000001'		; lsb set so is not zero
;test to speed up rate
;	andlw	B'00000011'
	movwf	QUIETING
	movlw	D'3'
	movwf	TIME			; quieting multiplier

; check LDR for light/darkness
CK_LDR
; only for modes above 4
	incf		MODE,w
	sublw	D'4'
	btfsc	STATUS,C		; if >4 run quieting counter from WDT for  LDR check
	goto	STOP

; quieting multiplier
	decfsz	TIME,f
	goto	STOP

; only run chirping occasionally (between 8s and 29m)
	movlw	D'3'				; reload
	movwf	TIME			; quieting multiplier
	movf	QUIETING,w
	btfsc	STATUS,Z		; when zero, reload and chirp
	goto	RELOAD
	decf	QUIETING,f
	goto	STOP
RELOAD
	movf	AARGB2,w		; random value
	iorlw 	B'00000001'		; lsb set so is not zero
; test to speed up rate
;	andlw	B'00000011'
	movwf	QUIETING

; MODES 5, 6, 7 and 8 run when dark
	incf		MODE,w
	xorlw	D'5'
	btfsc	STATUS,Z
	goto	DARK
	incf		MODE,w
	xorlw	D'6'
	btfsc	STATUS,Z
	goto	DARK
	incf		MODE,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	DARK
	incf		MODE,w
	xorlw	D'8'
	btfss	STATUS,Z
	goto	OTHER_MODES
DARK
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfsc	GPIO,2
	goto	T_READ			; when GPIO is high, then darkness, so read temperature
	goto	STOP

OTHER_MODES
; MODES 9, 10, 11 and 12 run when light
	incf		MODE,w
	xorlw	D'9'
	btfsc	STATUS,Z
	goto	LIGHT
	incf		MODE,w
	xorlw	D'10'
	btfsc	STATUS,Z
	goto	LIGHT
	incf		MODE,w
	xorlw	D'11'
	btfsc	STATUS,Z
	goto	LIGHT
	incf		MODE,w
	xorlw	D'12'
	btfss	STATUS,Z
	goto	T_READ			; MODES 13, 14, 15 and 16, run in any light or dark conditions

LIGHT
	bcf		GPIO,1			; switch on LDR divider
	nop
	nop
	nop						; settling time
	btfss	GPIO,2
	goto	T_READ			; when GPIO is low, then light, so read temperature

STOP
; SLEEP, low power mode
SHUT_DOWN
	bsf		GPIO,1			; LDR and NTC off
	bcf		INTCON,INTF		; GP2 interrupt flag cleared
	sleep					; stop operations
	nop

; awakes with watchdog timeout or interrupt with GP2 going low
 ; check if GP2 interrupt flag is high
	btfss	INTCON,INTF		; GP2 interrupt flag
	goto	CK_LDR		; not GP2. Check LDR level

T_READ ; temperature read
	bcf		GPIO,1			; LDR on, NTC thermistor on
	call		DELAYms		; delay for temperature value on NTC to settle
	call		ACQUIRE_AD
	bsf		GPIO,1			; LDR and NTC thermistor off
	movf	ADRESH,w	
; if  >197 use zero (ie no chirps)
	sublw	D'197'
	movf	ADRESH,w		; get A/D value again for use if =/<197
	btfss	STATUS,C
	goto	SHOW0			;  0 if over 197
; Lookup table for temperature
	call		TEMP_CALC	; value of temperature in deg C
	movwf	TEMPT
	movf	TEMPT,w			; check for 0
	btfss	STATUS,Z
	goto	CK_MODE

SHOW0; or less degrees C
; simple LED indication to indicate awake but too cold to report temperature
	bsf		GPIO,5			; LED2 on
; delay
	movlw	D'04'
	movwf	STORE3
TIMER_0
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_0
	bcf		GPIO,5			; LED off
	nop
	nop
	nop
	bsf		GPIO,4			; LED1 on
;delay
	movlw	D'04'
	movwf	STORE3
TIMER_01
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_01
	bcf		GPIO,4			; LED off
	goto	SHUT_DOWN	; no temperature reporting at 0 or below

CK_MODE ; check mode
;1
	incf		MODE,w
	xorlw	D'01'
	btfsc	STATUS,Z
	goto	MODE1
;2
	incf		MODE,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	MODE2
;3
	incf		MODE,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	MODE3
;4
	incf		MODE,w
	xorlw	D'04'
	btfsc	STATUS,Z
	goto	MODE4

;5
	incf		MODE,w
	xorlw	D'05'
	btfsc	STATUS,Z
	goto	MODE1
;6
	incf		MODE,w
	xorlw	D'06'
	btfsc	STATUS,Z
	goto	MODE2
;7
	incf		MODE,w
	xorlw	D'07'
	btfsc	STATUS,Z
	goto	MODE3
;8
	incf		MODE,w
	xorlw	D'08'
	btfsc	STATUS,Z
	goto	MODE4

;9
	incf		MODE,w
	xorlw	D'09'
	btfsc	STATUS,Z
	goto	MODE1
;10
	incf		MODE,w
	xorlw	D'10'
	btfsc	STATUS,Z
	goto	MODE2
;11
	incf		MODE,w
	xorlw	D'11'
	btfsc	STATUS,Z
	goto	MODE3
;12
	incf		MODE,w
	xorlw	D'12'
	btfsc	STATUS,Z
	goto	MODE4

;13
	incf		MODE,w
	xorlw	D'13'
	btfsc	STATUS,Z
	goto	MODE1
;14
	incf		MODE,w
	xorlw	D'14'
	btfsc	STATUS,Z
	goto	MODE2
;15
	incf		MODE,w
	xorlw	D'15'
	btfsc	STATUS,Z
	goto	MODE3
;16
	incf		MODE,w
	xorlw	D'16'
	btfsc	STATUS,Z
	goto	MODE4
;....................................................................................................
MODE1;  Temperature value reported in number of chirps
	movf	TEMPT,w		; temperature
	movwf	TEMP			; working value	

	call		CHIRP_LOOP	; random start up delay	
REPORT1
	call		SOUND			; chirp triplets
	call		TONE_GAP1		; gap between the triplet, varies with temperature (faster with higher temperature)

; check if temperature reporting has ended
	decfsz	TEMP,f
	goto	REPORT1		; continue reporting temperature count
	goto	SHUT_DOWN	; shut down cricket
;..................................................................................................................................
MODE2; temperature reported in fast set of 5's then the final count
	movf	TEMPT,w		; temperature
	movwf	TEMP			; working value
CYC2
	movf	TEMP,w
	btfsc	STATUS,Z		; if zero return
	goto	SHUT_DOWN
	sublw	D'4'				; if >4 do fives chirps
	btfsc	STATUS,C
	goto	REPORT2
	call		CHIRP_LOOP1	; random start up delay	
	goto	FIVES_CHIRP
; count out temperature below 5 degrees (or remainder after fives counting)
REPORT2
	movlw	D'100'
	call		DELAYX
	call		CHIRP_LOOP	; random start up delay	
	call		SOUND			; chirp triplets
	call		TONE_GAP		; gap between the triplet
; check if temperature reporting has ended
	decfsz	TEMP,f
	goto	REPORT2		; continue reporting temperature count
	goto	SHUT_DOWN	; shut down cricket
FIVES_CHIRP
	movlw	D'5'
	movwf	COUNT_VIX		; counter for in fives
FIVE_RUN
	call		SOUND			; chirp triplets
	movlw	D'60'			; up to 60 for faster rate 
	movwf	FASTER
	call		TONE_GAP2		; gap between the triplet, faster for fives count
	decf	TEMP,f			; reduce value
	decfsz	COUNT_VIX,f	; count down to 0
	goto	FIVE_RUN
	goto	CYC2 

;..................................................................................................................................
MODE3; temperature reported in fast set of 6's then the final count
	movf	TEMPT,w		; temperature
	movwf	TEMP			; working value
CYC3
	movf	TEMP,w
	btfsc	STATUS,Z		; if zero return
	goto	SHUT_DOWN
	sublw	D'5'				; if >5 do sixes chirps
	btfsc	STATUS,C
	goto	REPORT3
	call		CHIRP_LOOP1	; random start up delay	
	goto	SIXES_CHIRP
; count out temperature below 6 degrees (or remainder after sixes counting)
REPORT3
	movlw	D'100'
	call		DELAYX
	call		CHIRP_LOOP	; random start up delay	
	call		SOUND			; chirp triplets
	call		TONE_GAP		; gap between the triplet
; check if temperature reporting has ended
	decfsz	TEMP,f
	goto	REPORT3		; continue reporting temperature count
	goto	SHUT_DOWN	; shut down cricket
SIXES_CHIRP
	movlw	D'6'
	movwf	COUNT_VIX		; counter for in sixes
SIX_RUN
	call		SOUND			; chirp triplets
	movlw	D'60'			; up to 60 for faster rate 
	movwf	FASTER
	call		TONE_GAP2		; gap between the triplet, faster for Sixes count
	decf	TEMP,f			; reduce value
	decfsz	COUNT_VIX,f	; count down to 0
	goto	SIX_RUN
	goto	CYC3 
;...........................................................................................................................................
MODE4; temperature in tens (LED1) then 1's (LED2)
	movf	TEMPT,w		; temperature
	movwf	TEMP			; working value
CYC4
	movf	TEMP,w
	btfsc	STATUS,Z		; if zero return
	goto	SHUT_DOWN
	sublw	D'9'				; if >9 do 10's chirp
	btfsc	STATUS,C
	goto	REPORT4
	call		CHIRP_LOOP	; random start up delay	
	goto	TENS_CHIRP
; count out temperature below 10 degrees or remainder 
REPORT4
; show LED2
	bsf		GPIO,5			; LED2 on
; delay
	movlw	D'04'
	movwf	STORE3
TIMER_101
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_101
	bcf		GPIO,5			; LED off

	call		CHIRP_LOOP	; random start up delay	
	call		SOUND			; chirp triplets
	call		TONE_GAP		; gap between the triplet, faster for 10's count
; check if temperature reporting has ended
	decfsz	TEMP,f
	goto	REPORT4		; continue reporting temperature count
	goto	SHUT_DOWN	; shut down cricket

TENS_CHIRP
; show LED1
	bsf		GPIO,4			; LED1 on
; delay
	movlw	D'04'
	movwf	STORE3
TIMER_10
	movlw	D'255'
	call		DELAYX
	decfsz	STORE3,f
	goto	TIMER_10
	bcf		GPIO,4			; LED off

	movlw	D'10'
	movwf	COUNT_VIX		; counter for in 10's
TEN_RUN
	call		SOUND			; chirp triplets
	movlw	D'60'			; up to 60 for faster rate 
	movwf	FASTER
	call		TONE_GAP2		; gap between the triplet,
	decf	TEMP,f			; reduce value
	decfsz	COUNT_VIX,f	; count down to 0
	goto	TEN_RUN
	goto	CYC4 
; *****************************************************************************************************************************************************
; subroutines

; start up delay,  random
CHIRP_LOOP
	movf	AARGB3,w		; random value for delay
	iorlw	B'0000100'		; ensure minimum delay
	movwf 	STORE3			; delay extension
DEL_CONT1	
	movlw	D'13'			; delay routine
	call		DELAYX
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT1
	return

; start up delay,  random
CHIRP_LOOP1
	movf	AARGB3,w		; random value for delay
	iorlw	B'0000100'		; ensure minimum delay
	movwf 	STORE3			; delay extension
DEL_CONT11	
	movlw	D'23'			; delay routine
	call		DELAYX
	decfsz	STORE3,f		; when 0, exit delay
	goto	DEL_CONT11
	return

; chirp triplet (three bursts to represent a chirp)
SOUND
; Cricket
	clrwdt
	bsf		GPIO,1			; LDR off
	movlw	D'3'				; burst triplet 
	movwf	STORE3			; 3 x 4kHz bursts per chirp
CHIRP
	movf	AARGB0,w		; random value
	andlw	B'00001111'		; 16 max for lookup table
	call		BURST			; get burst length from lookup table
	movwf	STORE2			; individual burst length
	call		GENERATOR	; 4kHz tone (uses STORE1)
; gap between each burst of the triplet
CHIRP_GAP
	call		RAND32			; random number
	movf	AARGB1,w		; random value
	andlw	B'00000111'		; 8 max for lookup table
	call		GAP			; lookup table
	call		DELAYX
	decfsz	STORE3,f		; run 3 bursts
	goto	CHIRP
	return

; gap between the triplet (standard random)
TONE_GAP
	movlw	D'5'
	movwf	STORE3
TONE_GAP0
	call		RAND32			; random number
	movf	AARGB2,w
	andlw	B'00011111'		; max of 32 for lookup table
	call		SEPARATION	; lookup table		
 	call		DELAY_FX		; delay set by separation value
	decfsz	STORE3,f
	goto	TONE_GAP0
	return

; gap between the triplet (varies with temperature)
TONE_GAP1
	movlw	D'20'
	movwf	STORE3
	call		RAND32			; random number
TONE_GAP11
	movf	AARGB2,w
	andlw	B'00011111'		; max of 32 for lookup table
	call		SEPARATION	; 'w' has value >60
	movwf	TEMP0
	rrf		TEMPT,w 		; temperature (0-60)/2
	subwf	TEMP0,w		; 			
 	call		DELAYX			; delay set by separation value and temperature
	decfsz	STORE3,f
	goto	TONE_GAP11
	return

; gap between the triplet (varies with FASTER for counting fast in 5's, 6's or 10's)
TONE_GAP2
	movlw	D'5'
	movwf	STORE3
TONE_GAP22
	call		RAND32			; random number
	movf	AARGB2,w
	andlw	B'00011111'		; max of 32 for lookup table
	call		SEPARATION	; w has value >60
	movwf	TEMP0
	movf	FASTER,w	; up to 60 for fast rate
	subwf	TEMP0,w		; 			
 	call		DELAY_FX		; delay set by separation value 
	decfsz	STORE3,f
	goto	TONE_GAP22
	return

; 4kHz generator (set STORE2 before routine for burst length)	
GENERATOR
; divide burst length by 4
	bcf		STATUS,C
	rrf		STORE2,w		; /2
	movwf	SOFT_START		; soft start timer

	bcf		STATUS,C
	rrf		SOFT_START,f	; /4
	bcf		STATUS,C
	rrf		SOFT_START,f	; /8
	movf	SOFT_START,w
	movwf	SOFT_STORE
	subwf	STORE2,w
	movwf	SOFT_END		; soft end timer
	goto	GENERATOR1
GENERATOR2
	bsf		GPIO,5
	bcf		GPIO,4
	clrwdt
	movlw	D'40'			; frequency value 
	movwf	STORE1
DEC1
	decfsz	STORE1,f
	goto	DEC1	
	bcf		GPIO,5
	bsf		GPIO,4
	clrwdt
	movlw	D'40'			;  frequency value
	movwf	STORE1
DEC2
	decfsz	STORE1,f
	goto	DEC2
	decfsz	SOFT_END,f		; 4kHz burst length
	goto	GENERATOR2
	movf	SOFT_STORE,w
	movwf	SOFT_START
	goto	GENERATOR3

GENERATOR1
	bsf		GPIO,5
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC5
	decfsz	STORE1,f
	goto	DEC5	
	bcf		GPIO,5
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC6
	decfsz	STORE1,f
	goto	DEC6
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR1	; softer burst at half drive
	goto	GENERATOR2	; full burst drive

GENERATOR3
	bsf		GPIO,5
	clrwdt
	movlw	D'60'			; frequency value 
	movwf	STORE1
DEC3
	decfsz	STORE1,f
	goto	DEC3	
	bcf		GPIO,5
	clrwdt
	movlw	D'60'			;  frequency value
	movwf	STORE1
DEC4
	decfsz	STORE1,f
	goto	DEC4
	decfsz	SOFT_START,f	; 4kHz burst length
	goto	GENERATOR3	; softer burst at half drive
	bcf		GPIO,4			; LEDs off
	return

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	D'117'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	clrwdt
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_FLASH
	movlw	D'10'		; delay value
DELAY_FX
	movwf	STORE1		; STORE1 is number of loops value
LOOP10	
	movlw	D'11'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP11
	clrwdt
	decfsz	STORE2,f
	goto	LOOP11
	decfsz	STORE1,f
	goto	LOOP10
	return

; Subroutines

; read mode
EEREAD

	bsf 		STATUS,RP0 	; Bank 1
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address to read
	bsf 		EECON1,RD 	; EE Read
	movf 	EEDATA,w 	; Move data to w
	bcf		STATUS,RP0	; Bank 0
	return

; EEPROM write
EEWRITE
	clrwdt
	bsf 		STATUS,RP0 	; Bank 1
	movwf 	EEDATA		; data
	movlw 	EEPROM0		;
	movwf 	EEADR 		; Address
	bsf 		EECON1,WREN ; Enable write
;	bcf 	INTCON,GIE 	; Disable Interrupts
	movlw 	H'55'		; Unlock write
	movwf 	EECON2 		;
	movlw 	H'AA' 		;
	movwf 	EECON2 ;
	bsf 		EECON1,WR 	; Start the write
	bcf		STATUS,RP0	; Bank 0
	bcf		PIR1,EEIF	; clear end of write bit
WRITE
	btfsc	PIR1,EEIF
	goto	READY_RETURN
	clrwdt
	goto	WRITE
READY_RETURN
	bsf 		STATUS,RP0 	; Bank 1
	bcf 		EECON1,WREN ; disable write
	bcf		STATUS,RP0	; Bank 0
	return

; Random number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	Use:	CALL	RAND32

;	Output:	32 bit random integer in AARGB0, AARGB1, AARGB2, AARGB3

;	Result:	AARG  <--  RAND32( AARG )

;	Timing:	487	clocks

;	Linear congruential random number generator

;		X <- (a * X + c) mod m

;	The calculation is performed exactly, with multiplier a, increment c, and
;	modulus m, selected to achieve high ratings from standard spectral tests.
RANDOM
RAND32
		MOVF		RANDB0,W
		MOVWF		AARGB0
		MOVF		RANDB1,W
		MOVWF		AARGB1
		MOVF		RANDB2,W
		MOVWF		AARGB2
		MOVF		RANDB3,W
		MOVWF		AARGB3

		MOVLW		0x0D			; multiplier a = 1664525
		MOVWF		BARGB2
		MOVLW		0x66
		MOVWF		BARGB1
		MOVLW		0x19
		MOVWF		BARGB0

		CALL		FXM3224U

        	INCF        	AARGB6,F		; c = 1
        	BTFSC      	 STATUS,Z
       		 INCF        	AARGB5,F
		BTFSC		STATUS,Z
		INCF		AARGB4,F
		BTFSC		STATUS,Z
		INCF		AARGB3,F
		BTFSC       	STATUS,Z
       		INCF       	 AARGB2,F
		BTFSC		STATUS,Z
		INCF		AARGB1,F
		BTFSC		STATUS,Z
		INCF		AARGB0,F

		MOVF		AARGB3,W
		MOVWF		RANDB0			; m = 2**32
		MOVF		AARGB4,W
		MOVWF		RANDB1
		MOVF		AARGB5,W
		MOVWF		RANDB2
		MOVF		AARGB6,W
		MOVWF		RANDB3

		RETLW		0x00

;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
                CLRF    AARGB4          ; clear partial product
                CLRF    AARGB5
                CLRF    AARGB6
                MOVF  	AARGB0,W
                MOVWF   TEMPB0
                MOVF   	AARGB1,W
                MOVWF   TEMPB1
                MOVF   	AARGB2,W
                MOVWF   TEMPB2
                MOVF   	AARGB3,W
                MOVWF   TEMPB3

                CALL 	UMUL3224L

                RETLW           0x00

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       MOVLW   0x08
                MOVWF   LOOPCOUNT

LOOPUM3224A
                RRF     BARGB2,F
                BTFSC   STATUS,C
                GOTO    ALUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224A

                MOVWF   LOOPCOUNT

LOOPUM3224B
                RRF     BARGB1,F
                BTFSC   STATUS,C
                GOTO    BLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224B

                MOVWF   LOOPCOUNT

LOOPUM3224C
                RRF     BARGB0,F
                BTFSC   STATUS,C
                GOTO    CLUM3224NAP
                DECFSZ  LOOPCOUNT,F
                GOTO    LOOPUM3224C

                CLRF    AARGB0
                CLRF    AARGB1
                CLRF    AARGB2
                CLRF    AARGB3
                RETLW   0x00
                
ALUM3224NAP     BCF     STATUS,C
                GOTO    ALUM3224NA
                
BLUM3224NAP     BCF     STATUS,C
                GOTO    BLUM3224NA
                
CLUM3224NAP     BCF     STATUS,C
                GOTO    CLUM3224NA

ALOOPUM3224
                RRF     BARGB2,F
                BTFSS   STATUS,C
                GOTO    ALUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

ALUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                DECFSZ  LOOPCOUNT,F
                GOTO    ALOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

BLOOPUM3224
                RRF     BARGB1,F
                BTFSS   STATUS,C
                GOTO    BLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

BLUM3224NA
                RRF    	AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                DECFSZ  LOOPCOUNT,F
                GOTO    BLOOPUM3224

                MOVLW   0x08
                MOVWF   LOOPCOUNT

CLOOPUM3224
                RRF     BARGB0,F
                BTFSS   STATUS,C
                GOTO    CLUM3224NA
                MOVF    TEMPB3,W
                ADDWF   AARGB3,F
                MOVF    TEMPB2,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB2,W
                ADDWF   AARGB2,F
                MOVF    TEMPB1,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB1,W
                ADDWF   AARGB1,F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0,F

CLUM3224NA
                RRF     AARGB0,F
                RRF     AARGB1,F
                RRF     AARGB2,F
                RRF     AARGB3,F
                RRF     AARGB4,F
                RRF     AARGB5,F
                RRF     AARGB6,F
                DECFSZ  LOOPCOUNT,F
                GOTO    CLOOPUM3224
				RETURN	
                

	end
